


EntityEvents.hurt('rats:ratlantean_automaton', event => {
    if (event.source.player) return
    if (event.source.immediate == null) return
    if (!event.source.immediate.type.toString().includes('guiding_bolt')) return
    event.cancel()
})



EntityEvents.spawned('rats:ratlantean_automaton', event => {
    let players = event.level.players
    players.forEach(player => {
        Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete 74890EF7B16A823C`)
    })
    Utils.server.scheduleInTicks(45, t => {
        let entity = event.entity
        let box = AABB.of(event.entity.x+30, event.entity.y+30, event.entity.z+30, event.entity.x-30, event.entity.y-30, event.entity.z-30)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        if (event.entity.alive) {
            t.repeating = true
            entitiesWithin.forEach(ent => {
                if (!ent.player && !ent.tags.contains('tamed_beast')) return
                // choose random spell
                let strike = event.level.createEntity('irons_spellbooks:guiding_bolt')
                strike.setPosition(entity.x, entity.y+5.5, entity.z)
                strike.mergeNbt('{ExplosionRadius:10, Damage:5, Glowing:true, Tags:["automat"]}')
                strike.spawn()
                strike.playSound('blue_skies:entity.gatekeeper.prepare_regen', 10, 1)
                strike.addMotion(0, 0.55, 0)
                Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:amber_monolith ${strike.x} ${strike.y} ${strike.z} 0.5 0.5 0.5 1000000 30 normal`)
                Utils.server.scheduleInTicks(6, () => {
                    Utils.server.scheduleInTicks(1, e => {
                        if (strike.alive) {
                            let dir = {
                                x: ent.getX() - strike.getX(),
                                y: ent.getY()+(ent.eyeHeight-0.25) - strike.getY(),
                                z: ent.getZ() - strike.getZ()
                            };
                            let dirLength = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
                            if (dirLength > 0) {
                                strike.setMotion((dir.x / dirLength) * 0.2, (dir.y / dirLength) * 0.2, (dir.z / dirLength) * 0.2);
                                e.repeating = true
                            }
                        }
                    })
                })

            })
        } else {
            t.repeating = false
        }

    })
})

/**
 * EntityEvents.spawned('rats:ratlantean_automaton', event => {
    let entity = event.entity
    Utils.server.scheduleInTicks(100, ev => {
        if (!entity.alive) return
        let box = AABB.of(entity.x+30, entity.y+15, entity.z+30, entity.x-30, entity.y-15, entity.z-30)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        if (entitiesWithin.length == 0) {
            ev.repeating = false
        } else {
            ev.repeating = true
        }
        entitiesWithin.forEach(ent => {
            if (!ent.player && !ent.tags.contains('tamed_beast')) return
            let strike = event.level.createEntity('mowziesmobs:sunstrike')
            strike.setPosition(ent.x, ent.y, ent.z)
            strike.spawn()
            Utils.server.scheduleInTicks(47, () => {
                strike.kill()
            })
            Utils.server.scheduleInTicks(1, e => {
                if (strike.alive) {
                    e.repeating = true
                    strike.teleportTo(ent.x, ent.y, ent.z)
                }
            })
        })
    })

})
 * 
 * 
 */



/**
 * 
 * 
 * 

EntityEvents.spawned('hs_bosses:sand_warrior', event => {
    let entity = event.entity
    Utils.server.scheduleInTicks(100, ev => {
        if (!entity.alive) return
        let box = AABB.of(entity.x+20, entity.y+10, entity.z+20, entity.x-20, entity.y-10, entity.z-20)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box)
        if (entitiesWithin.length == 0) {
            ev.repeating = false
        } else {
            ev.repeating = true
        }
        entitiesWithin.forEach(ent => {
            if (!ent.player && !ent.tags.contains('tamed_beast')) return
            let strike = event.level.createEntity('irons_spellbooks:comet')
            strike.setPosition(ent.x, ent.y+10, ent.z)
            strike.spawn()
            Utils.server.scheduleInTicks(50, () => {
                strike.kill()
            })
            Utils.server.scheduleInTicks(1, e => {
                if (strike.alive) {
                    let dir = {
                        x: ent.getX() - strike.getX(),
                        y: ent.getY() - strike.getY(),
                        z: ent.getZ() - strike.getZ()
                    };
                    let dirLength = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
                    if (dirLength > 0) {
                        strike.setMotion((dir.x / dirLength) * 0.1, (dir.y / dirLength) * 0.1, (dir.z / dirLength) * 0.1);
                        e.repeating = true
                    }
                    
                }
            })
        })
    })

})

 * 
 */
